/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.jfronny.libjf.config.impl;

import io.gitlab.jfronny.commons.serialize.emulated.DataElement;
import io.gitlab.jfronny.libjf.config.api.v2.Category;
import io.gitlab.jfronny.libjf.config.api.v2.JfConfig;
import io.gitlab.jfronny.libjf.config.api.v2.dsl.CategoryBuilder;
import io.gitlab.jfronny.libjf.serialize.FabricLoaderDataMapper;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.metadata.CustomValue;
import org.jetbrains.annotations.Nullable;

public class AuxiliaryMetadata {
    public List<String> referencedConfigs;

    public static AuxiliaryMetadata of(Category category) {
        AuxiliaryMetadata meta = new AuxiliaryMetadata();
        if (category != null) {
            meta.referencedConfigs = List.of(category.referencedConfigs());
        }
        return meta.sanitize();
    }

    public static AuxiliaryMetadata of(JfConfig config) {
        AuxiliaryMetadata meta = new AuxiliaryMetadata();
        if (config != null) {
            meta.referencedConfigs = List.of(config.referencedConfigs());
        }
        return meta.sanitize();
    }

    @Nullable
    public static AuxiliaryMetadata forMod(String modId) {
        var metaRef = new Object(){
            AuxiliaryMetadata meta = null;
        };
        FabricLoader.getInstance().getModContainer(modId).ifPresent(container -> {
            CustomValue cv = container.getMetadata().getCustomValue("libjf:config");
            if (cv == null && (cv = container.getMetadata().getCustomValue("libjf")) != null) {
                cv = cv.getAsObject().get("config");
            }
            if (cv != null) {
                metaRef.meta = AuxiliaryMetadata.read(FabricLoaderDataMapper.toGson((CustomValue)cv));
            }
        });
        return metaRef.meta;
    }

    public static AuxiliaryMetadata read(DataElement data) {
        if (!(data instanceof DataElement.Object)) {
            throw new IllegalArgumentException("AuxiliaryMetadata must be an object");
        }
        DataElement.Object obj = (DataElement.Object)data;
        AuxiliaryMetadata meta = new AuxiliaryMetadata();
        block6: for (Map.Entry entry : obj.members().entrySet()) {
            switch ((String)entry.getKey()) {
                case "referencedConfigs": {
                    Object v = entry.getValue();
                    if (!(v instanceof DataElement.Array)) {
                        throw new IllegalArgumentException("referencedConfigs must be an array");
                    }
                    DataElement.Array arr = (DataElement.Array)v;
                    meta.referencedConfigs = new LinkedList<String>();
                    arr.elements().forEach(element -> {
                        if (!(element instanceof DataElement.Primitive.String)) {
                            throw new IllegalArgumentException("referencedConfigs must be an array of strings");
                        }
                        DataElement.Primitive.String str = (DataElement.Primitive.String)element;
                        meta.referencedConfigs.add(str.value());
                    });
                    continue block6;
                }
            }
            throw new IllegalArgumentException("Unknown key in AuxiliaryMetadata: " + (String)entry.getKey());
        }
        return meta;
    }

    public void applyTo(CategoryBuilder<?> builder) {
        if (this.referencedConfigs != null) {
            this.referencedConfigs.forEach(builder::referenceConfig);
        }
    }

    public AuxiliaryMetadata sanitize() {
        this.referencedConfigs = this.referencedConfigs == null ? List.of() : List.copyOf(this.referencedConfigs);
        return this;
    }

    public AuxiliaryMetadata merge(AuxiliaryMetadata other) {
        if (other == null) {
            return this;
        }
        AuxiliaryMetadata meta = new AuxiliaryMetadata();
        meta.referencedConfigs = new LinkedList<String>();
        meta.referencedConfigs.addAll(this.referencedConfigs);
        meta.referencedConfigs.addAll(other.referencedConfigs);
        return meta.sanitize();
    }
}

